' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data

''' <summary>
''' Klasa Download reprezentuje plik do pobrania.
''' Klasa Download dziedziczy z ContentBase, ktra dostarcza podstawowych waciwoci takich jak Id i Title.
''' </summary>
Public Class Download
  Inherits ContentBase

#Region "Zmienne prywatne"

  Private _downloadUrl As String = String.Empty

#End Region

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Konstruktor domylny.
  ''' </summary>
  Public Sub New()

  End Sub

  Public Sub New(ByVal id As Integer)
    MyBase.New(id)
  End Sub

#End Region

#Region "Metody publiczne"

  ''' <summary>
  ''' Pobiera Download z bazy danych wywoujc metod Get() klasy DownloadDB.
  ''' </summary>
  Public Shared Function [Get](ByVal id As Integer) As Download
    Return DownloadDB.Get(id)
  End Function

  ''' <summary>
  ''' Zapisuje Download w bazie danych wywoujc metod Save() klasy DownloadDB.
  ''' </summary>
  Public Overrides Sub Save()
    DownloadDB.Save(Me)
  End Sub

  ''' <summary>
  ''' Usuwa Download z bazy danych wywoujc metod Delete() klasy DownloadDB.
  ''' </summary>
  Public Shared Sub Delete(ByVal id As Integer)
    DownloadDB.Delete(id)
  End Sub

  ''' <summary>
  ''' Zwraca list list plikw do pobrania jako DataSet.
  ''' </summary>
  ''' <param name="categoryId">Identyfikator kategorii w bazie danych dla ktrej maj by zwrceone pliki do pobrania.</param>
  Public Shared Function GetDownloadList(ByVal categoryId As Integer, ByRef recordsAffected As Integer) As DataSet
    Dim dsDownloads As DataSet = DownloadDB.GetDownloadList(categoryId)
    recordsAffected = dsDownloads.Tables(0).Rows.Count
    Return dsDownloads
  End Function

  ''' <summary>
  ''' Zwraca list plikw do pobrania jako DataSet.
  ''' </summary>
  Public Shared Function GetDownloadList(ByRef recordsAffected As Integer) As DataSet
    Dim dsDownloads As DataSet = DownloadDB.GetDownloadList(-1)
    recordsAffected = dsDownloads.Tables(0).Rows.Count
    Return dsDownloads
  End Function

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Pobiera lub ustawia ciek wirtualn do pliku do pobrania.
  ''' </summary>
  Public Property DownloadUrl() As String
    Get
      Return _downloadUrl
    End Get

    Set(ByVal value As String)
      _downloadUrl = value
    End Set
  End Property

#End Region

End Class
